/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.block;

import dev.toma.gunsrpg.common.block.BaseBlock;
import dev.toma.gunsrpg.common.container.CrateContainer;
import dev.toma.gunsrpg.common.tileentity.ILootGenerator;
import dev.toma.gunsrpg.common.tileentity.InventoryTileEntity;
import dev.toma.gunsrpg.util.ModUtils;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkHooks;

public abstract class AbstractCrateBlock
extends BaseBlock {
    public AbstractCrateBlock(String name, AbstractBlock.Properties properties) {
        super(name, properties);
    }

    public abstract ITextComponent getContainerTitle();

    public abstract boolean shouldDestroyEmptyBlock();

    public abstract <T extends InventoryTileEntity> T getNewBlockEntity();

    public final void func_225542_b_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        ILootGenerator generator;
        if (!this.shouldDestroyEmptyBlock()) {
            return;
        }
        TileEntity entity = world.func_175625_s(pos);
        if (entity instanceof ILootGenerator && (generator = (ILootGenerator)entity).isEmptyInventory()) {
            world.func_175655_b(pos, false);
        }
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState oldState, boolean p_196243_5_) {
        if (!state.func_203425_a(oldState.func_177230_c())) {
            ModUtils.dropInventoryItems(world, pos);
        }
        super.func_196243_a(state, world, pos, oldState, p_196243_5_);
    }

    public final boolean hasTileEntity(BlockState state) {
        return true;
    }

    public final TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return this.getNewBlockEntity();
    }

    public final INamedContainerProvider func_220052_b(BlockState state, World world, BlockPos pos) {
        return new SimpleNamedContainerProvider((windowID, playerInventory, player) -> new CrateContainer<InventoryTileEntity>(windowID, playerInventory, (InventoryTileEntity)((Object)((Object)((ILootGenerator)((Object)((InventoryTileEntity)world.func_175625_s(pos))))))), this.getContainerTitle());
    }

    public final ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult result) {
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)state.func_215699_b(world, pos), (BlockPos)pos);
        return ActionResultType.CONSUME;
    }

    public final List<ItemStack> func_220076_a(BlockState p_220076_1_, LootContext.Builder p_220076_2_) {
        return Collections.emptyList();
    }
}

